/* Tile */

#import <Cocoa/Cocoa.h>
#import "MJSConstants.h"

#define TILEFLAG_HIGHLIGHT 1
#define TILEFLAG_HIDDEN    2

#ifdef LEVEL_EDITOR
#define TILE_WIDTH 42
#define TILE_HEIGHT 48
#else
#define TILE_WIDTH 56
#define TILE_HEIGHT 64
#endif


@interface Tile : NSObject
{
    int x,y;
    int tile_id;
    int flags;
    int array_x,array_y;
    int layer;
    float life;
	int array_pos;
	float rotate_stage;
	BOOL blanked;
}

- (id)init :(int)x :(int)y :(int)id :(int)array_x :(int)array_y :(int)layer;
- (id)initWithTile :(Tile*)tile;
- (int)flags;
- (id)setFlags :(int)flags;
- (int)arrayX;
- (int)arrayY;
- (id)setArrayPos :(int)x :(int)y :(int)layer;
- (int)layer;
- (int)logicalTileID :(id)collection;
- (int)actualTileID;
- (id)setID :(int)id_value;
- (float)life;
- (void)setLife :(float)value;
- (NSRect)tileRect;
- (NSRect)minTileRect;
- (BOOL)visible;
- (int)X;
- (int)Y;
- (void)setXY :(int)x :(int)y;
- (id)setArrayPos :(int)pos;
- (int)arrayPos;
- (int)makeID;
- (id)setBlank :(BOOL)value;
- (BOOL)isBlank;
- (float)rotateStage;
- (id)setRotateStage :(float)value;

@end
